;----------------------------------------------------------------------------
; Atari Jaguar
; Project Tempest .95
; by BBB
; 1.1
;
; Notes:
; Set Fullscreen mode within Project Tempest
; Settings -> Settings -> Video -> Fullscreen Mode
;
;----------------------------------------------------------------------------

DetectHiddenWindows, On
SetWinDelay, 10

;This will run PT minimized while opening rom, you can change to Hide
Run, "%EmuPath%%Executable%" ,,Min 

;Wait for the main window even if its minimzed                                  
WinWait, Tempest                              

;Open the select rom dialog
WinMenuSelectItem, Tempest, ,1&, 1&

;This fully ensures dialogs are completely hidden even faster than winwait
SetTimer, WaitForDialog, 2

;Wait for rom dialog
WinWaitActive, ROM 

;Sleep just to ensure controls are accessible                      
Sleep,1000  

;Loop through controls to double check they are accessible.  Then set rom
Rom = %RomPath%%RomName%%RomExtension%                                                  
Loop {
    ControlGet, Txt, Line, 1, Edit1, ROM
    If (Txt=Rom){
      break
    }else{
      Control, EditPaste, %Rom%, Edit1, ROM
      WinActivate, ROM
    }
 }   

;Start game 
Send {ENTER}
Sleep, 1000
SetTimer, WaitForDialog, Off

;Some roms might display download screen
IfWinActive, download
{
  ControlClick, Cancel, download
  Goto Error
}

;If rompath never got sent for any reason
IfWinActive, ROM
{
  Goto Error
}
 
;Wait till game is done 
Process, WaitClose, %Executable%                                                                                                      
ExitApp 

Error:
    MsgBox, 0, Error, There was an error.`nTry running outside HL to see error., 2
    Goto CloseProcess
return                                                                                

WaitForDialog:
IfWinNotExist, ROM
{
   return
}else{
  WinSet, Transparent, 0, ROM
  WinSet, Transparent, 0, download
}
return
           
CloseProcess:
WinClose, Tempest
ExitApp 
return